// priority: 180
onEvent('recipes', (event) => {
    //Empty Recipe template for when they are disabled on servers
    const emptyRecipe = (item) => {
        event.shapeless(item, Item.of('minecraft:barrier', "{RepairCost:0,display:{Name:'{\"text\":\"Disabled on this server\"}'}}"));
    }

    //If limited creative item recipes are turned on.
    //This can be useful for servers with some kind of economy and that want to limit item duplications in later stages.
    //----------------------------------------------
    //Items that can be disabled are below this line
    //----------------------------------------------
    if (global.gamemodeFile && global.gamemodeFile.limitCreativeItemRecipes) {
        let disabledItems = [
            'ars_nouveau:creative_source_jar',
            'ars_nouveau:creative_spell_book',
            'botania:lens_storm',
            'create:creative_motor',
            'littlelogistics:creative_capacitor',
            'pneumaticcraft:creative_compressor',
            Item.of('botania:mana_tablet', '{creative:1b,mana:500000}'),
            'botania:corporea_spark_creative',
            'create:creative_crate',
            'create:creative_fluid_tank',
            'mekanism:creative_bin',
            Item.of('modularrouters:creative_module', '{modularrouters:{ModuleFilter:{}}}'),
            'pneumaticcraft:creative_upgrade',
            'mekanism:creative_fluid_tank',
            'mekanism:creative_chemical_tank',
            'thermal:fluid_tank_creative_augment',
            'storagedrawers:creative_vending_upgrade',
            'malum:creative_scythe',
            'createaddition:creative_energy',
            'immersiveengineering:capacitor_creative',
            Item.of('mekanism:creative_energy_cube', '{mekData:{EnergyContainers:[{Container:0b,stored:"18446744073709551615.9999"}]}}'),
            'rftoolspower:dimensionalcell_creative',
            'thermal:rf_coil_creative_augment',
            'botania:creative_pool'
        ]
        disabledItems.forEach((item) => {
            emptyRecipe(item);
        });
    }
    else {
        //Else they aren't disabled, just give them normal intended recipes!

        //Ars Nouveau Creative Source Jar
        event.smithing('ars_nouveau:creative_source_jar', Item.of('ars_nouveau:source_jar', '{BlockEntityTag:{Items:[],id:"ars_nouveau:source_jar",source:10000}}'), 'kubejsadditions:power_globe');

        //Ars Nouveau Creative Spell Book
        event.smithing('ars_nouveau:creative_spell_book', 'ars_nouveau:archmage_spell_book', 'kubejsadditions:power_globe');

        //Botania Storm Lens
        event.smithing('botania:lens_storm', 'botania:lens_normal', 'kubejsadditions:power_globe');

        //Create Creative Motor
        event.smithing('create:creative_motor', 'createaddition:electric_motor', 'kubejsadditions:power_globe');

        //Little Logistics Creative Capacitor
        event.smithing('littlelogistics:creative_capacitor', 'littlelogistics:vessel_charger', 'kubejsadditions:power_globe');

        //PneumaticCraft Creative Compressor
        event.smithing('pneumaticcraft:creative_compressor', 'pneumaticcraft:advanced_air_compressor', 'kubejsadditions:power_globe');

        //Botania Creative Mana Tablet
        event.smithing(Item.of('botania:mana_tablet', '{creative:1b,mana:500000}'), 'botania:creative_pool', 'botania:mana_tablet');

        //Botania Creative Corporea Spark
        event.smithing('botania:corporea_spark_creative', 'botania:spark', 'storagedrawers:creative_vending_upgrade');

        //Create Creative Crate
        event.smithing('create:creative_crate', 'bettercrates:wooden_crate', 'storagedrawers:creative_vending_upgrade');

        //Create Creative Fluid Tank
        event.smithing('create:creative_fluid_tank', 'create:fluid_tank', 'storagedrawers:creative_vending_upgrade');

        //Mekanism Creative Bin
        event.smithing('mekanism:creative_bin', 'mekanism:basic_bin', 'storagedrawers:creative_vending_upgrade');

        //Modular Routers Creative Module
        event.smithing(Item.of('modularrouters:creative_module', '{modularrouters:{ModuleFilter:{}}}'), 'modularrouters:blank_module', 'storagedrawers:creative_vending_upgrade');

        //PneumaticCraft Creative Supply Upgrade
        event.smithing('pneumaticcraft:creative_upgrade', 'pneumaticcraft:omnidirectional_hopper', 'storagedrawers:creative_vending_upgrade');

        //Mekanism Creative Tank
        event.smithing('mekanism:creative_fluid_tank', 'mekanism:basic_fluid_tank', 'storagedrawers:creative_vending_upgrade');

        //Mekanism Creative Chemical Tank
        event.smithing('mekanism:creative_chemical_tank', 'mekanism:basic_chemical_tank', 'storagedrawers:creative_vending_upgrade');

        //Thermal Creative Tank Augment
        event.smithing('thermal:fluid_tank_creative_augment', 'thermal:fluid_tank_augment', 'storagedrawers:creative_vending_upgrade');

        //Creative Mana Pool
        event.custom({
            "type": "botania:terra_plate",
            "mana": 9000000,
            "ingredients": [
                {
                    "item": "botania:fabulous_pool"
                },
                {
                    "item": "kubejsadditions:power_globe"
                },
                {
                    "item": "mysticalagriculture:supremium_gemstone_block"
                }
            ],
            "result": {
                "item": "botania:creative_pool"
            }
        });

        //Storage Drawers Creative Vending Upgrade
        event.custom({
            "type": "pneumaticcraft:pressure_chamber",
            "inputs": [
                {
                    "type": "pneumaticcraft:stacked_item",
                    "tag": "malum:soulwood_logs",
                    "count": 64
                },
                {
                    "item": "compressium:quartz_5"
                },
                {
                    "type": "pneumaticcraft:stacked_item",
                    "tag": "tconstruct:slimy_logs",
                    "count": 64
                },
                {
                    "item": "compressium:clay_5"
                },
                {
                    "item": "storagedrawers:creative_storage_upgrade"
                },
                {
                    "tag": "kubejadditions:compressed_soils"
                },
                {
                    "type": "pneumaticcraft:stacked_item",
                    "tag": "botania:dreamwood_logs",
                    "count": 64
                },
                {
                    "tag": "kubejsadditions:compressed_ores"
                },
                {
                    "type": "pneumaticcraft:stacked_item",
                    "item": "occultism:otherworld_log",
                    "count": 64
                }
            ],
            "pressure": 4.5,
            "results": [
                {
                    "item": "storagedrawers:creative_vending_upgrade"
                }
            ]
        });

        //Malum Creative Scythe
        event.custom({
            "type": "ars_nouveau:enchanting_apparatus",
            "reagent": [
                {
                    "item": 'malum:soul_stained_steel_scythe'
                }
            ],
            "pedestalItems": [
                {
                    "item": {
                        "item": 'kubejsadditions:power_globe'
                    }
                },
                {
                    "item": {
                        "item": 'mysticalagriculture:supremium_ingot'
                    }
                },
                {
                    "item": {
                        "item": 'mysticalagriculture:supremium_ingot'
                    }
                },
                {
                    "item": {
                        "item": 'minecraft:netherite_ingot'
                    }
                },
                {
                    "item": {
                        "item": 'minecraft:netherite_ingot'
                    }
                },
                {
                    "item": {
                        "item": 'rftoolsbase:infused_diamond'
                    }
                },
                {
                    "item": {
                        "item": 'rftoolsbase:infused_diamond'
                    }
                }
            ],
            "output": {
                "item": 'malum:creative_scythe'
            },
            "sourceCost": 10000
        });

        //Create Addition Creative Generator (RF)
        event.recipes.create.mechanical_crafting('createaddition:creative_energy',
            ['ABCBA', 'BDEDB', 'CEFEC', 'BDEDB', 'ABCBA'],
            {
                A: 'kubejsadditions:nether_star_shard',
                B: 'ae2:charged_certus_quartz_crystal',
                C: 'mysticalagriculture:supremium_ingot',
                D: 'compressium:redstone_3',
                E: 'kubejsadditions:tesseracted_plexiglass',
                F: 'create:steam_engine'
            }
        );

        //Immersive Engineering Creative Capacitor
        event.recipes.create.mechanical_crafting('immersiveengineering:capacitor_creative',
            ['ABCBA', 'BDEDB', 'CEFEC', 'BDEDB', 'ABCBA'],
            {
                A: 'kubejsadditions:nether_star_shard',
                B: 'ae2:charged_certus_quartz_crystal',
                C: 'mysticalagriculture:supremium_ingot',
                D: 'compressium:redstone_3',
                E: 'kubejsadditions:tesseracted_plexiglass',
                F: 'immersiveengineering:capacitor_lv'
            }
        );

        //Mekanism Creative Energy Cube
        event.recipes.create.mechanical_crafting(Item.of('mekanism:creative_energy_cube', '{mekData:{EnergyContainers:[{Container:0b,stored:"18446744073709551615.9999"}]}}'),
            ['ABCBA', 'BDEDB', 'CEFEC', 'BDEDB', 'ABCBA'],
            {
                A: 'kubejsadditions:nether_star_shard',
                B: 'ae2:charged_certus_quartz_crystal',
                C: 'mysticalagriculture:supremium_ingot',
                D: 'compressium:redstone_3',
                E: 'kubejsadditions:tesseracted_plexiglass',
                F: 'mekanism:basic_energy_cube'
            }
        );

        //RFTools Creative Dimensional Cell
        event.recipes.create.mechanical_crafting('rftoolspower:dimensionalcell_creative',
            ['ABCBA', 'BDEDB', 'CEFEC', 'BDEDB', 'ABCBA'],
            {
                A: 'kubejsadditions:nether_star_shard',
                B: 'ae2:charged_certus_quartz_crystal',
                C: 'mysticalagriculture:supremium_ingot',
                D: 'compressium:redstone_3',
                E: 'kubejsadditions:tesseracted_plexiglass',
                F: 'rftoolspower:dimensionalcell'
            }
        );

        //Thermal Creative RF Augment
        event.recipes.create.mechanical_crafting('thermal:rf_coil_creative_augment',
            ['ABCBA', 'BDEDB', 'CEFEC', 'BDEDB', 'ABCBA'],
            {
                A: 'kubejsadditions:nether_star_shard',
                B: 'ae2:charged_certus_quartz_crystal',
                C: 'mysticalagriculture:supremium_ingot',
                D: 'compressium:redstone_3',
                E: 'kubejsadditions:tesseracted_plexiglass',
                F: 'thermal:rf_coil_augment'
            }
        );
    }

    //-------------------------------------------------
    //Items that are always enabled are below this line
    //-------------------------------------------------

    //AE2 Creative Energy Cell
    event.smithing('ae2:creative_energy_cell', 'ae2:dense_energy_cell', 'kubejsadditions:power_globe');

    //The Creative Probe
    event.smithing('theoneprobe:creativeprobe', 'theoneprobe:probe', 'kubejsadditions:power_globe');

    //Storage Drawers Creative Storage Upgrade
    const cells = ['ae2:cell_component_256k', 'mekanism:qio_drive_time_dilating']
    event.shaped('storagedrawers:creative_storage_upgrade', ['SSS', 'CUC', 'SSS'], {
        S: '#forge:rods/wooden',
        C: cells,
        U: 'storagedrawers:upgrade_template'
    })

    //Building Gadgets Construction Paste
    event.smithing('buildinggadgets:construction_paste_container_creative', Item.of('buildinggadgets:construction_paste_container_t3', '{amount:8192}'), 'kubejsadditions:power_globe');

    //Create Creative Blaze Cake
    event.smithing('create:creative_blaze_cake', 'create:blaze_cake', 'kubejsadditions:power_globe');

    //Creative Soulium Dagger
    event.smithing('mysticalagriculture:creative_soulium_dagger', 'mysticalagriculture:soulium_dagger', 'kubejsadditions:power_globe');

    //PneumaticCraft Compressed Iron Block
    event.smithing('pneumaticcraft:creative_compressed_iron_block', 'pneumaticcraft:compressed_iron_block', 'kubejsadditions:power_globe');

    //RFTools Creative Screen
    event.smithing('rftoolsutility:creative_screen', 'rftoolsutility:screen', 'kubejsadditions:power_globe');

    //Thermal Creative Efficiency Augment
    event.smithing('thermal:machine_efficiency_creative_augment', 'thermal:machine_efficiency_augment', 'kubejsadditions:power_globe');

    //Thermal Creative Catalyst Augment
    event.smithing('thermal:machine_catalyst_creative_augment', 'thermal:machine_catalyst_augment', 'kubejsadditions:power_globe');

    //Tinker's Construct Creative slot modifiers
    event.smithing(Item.of('tconstruct:creative_slot', '{slot:"upgrades"}'), 'tconstruct:seared_reinforcement', 'kubejsadditions:power_globe');
    event.smithing(Item.of('tconstruct:creative_slot', '{slot:"defense"}'), 'tconstruct:emerald_reinforcement', 'kubejsadditions:power_globe');
    event.smithing(Item.of('tconstruct:creative_slot', '{slot:"abilities"}'), 'tconstruct:bronze_reinforcement', 'kubejsadditions:power_globe');
    event.smithing(Item.of('tconstruct:creative_slot', '{slot:"souls"}'), 'tconstruct:iron_reinforcement', 'kubejsadditions:power_globe');
});
